import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay/core/utils/my_strings.dart';
import 'package:viserpay/core/utils/util.dart';
import 'package:viserpay/data/model/authorization/authorization_response_model.dart';
import 'package:viserpay/data/model/global/response_model/response_model.dart';
import 'package:viserpay/data/model/savings/installment/installment_response_model.dart';
import 'package:viserpay/data/model/savings/savings_history_response_model.dart';
import 'package:viserpay/data/repo/saving/saving_repo.dart';
import 'package:viserpay/view/components/snack_bar/show_custom_snackbar.dart';

class SavingsHistoryController extends GetxController {
  SavingRepo repo;
  SavingsHistoryController({required this.repo});

  List<DpsHistoryData> runningDpsList = [];
  List<DpsHistoryData> matureDpsList = [];
  List<DpsHistoryData> closedDpsList = [];
  String organizationImagePath = "";
  bool isLoading = true;
  void initialize() {
    runningDpsList = [];
    getDpsHistory();
  }

  Future<void> getDpsHistory() async {
    try {
      ResponseModel responseModel = await repo.getDPSHistory("1");
      if (responseModel.statusCode == 200) {
        SavingsHistoryResponseModel model = SavingsHistoryResponseModel.fromJson(jsonDecode(responseModel.responseJson));
        if (model.status == "success") {
          runningDpsList = model.data?.accounts?.running ?? [];
          matureDpsList = model.data?.accounts?.matured ?? [];
          closedDpsList = model.data?.accounts?.canceled ?? [];
          organizationImagePath = model.data?.organizationImagePath ?? "";
        } else {
          CustomSnackBar.error(errorList: model.message?.error ?? [MyStrings.somethingWentWrong]);
        }
      } else {
        CustomSnackBar.error(errorList: [responseModel.message]);
      }
    } catch (e) {
      printX(e);
    } finally {
      isLoading = false;
      update();
    }
  }

  bool isDetailsLoading = true;
  List<Installment> installment = [];
  String id = "";
  DpsHistoryData? dps;
  Future<void> getDpsDetails() async {
    installment = [];
    id = Get.arguments;
    dps = null;
    isDetailsLoading = true;
    update();
    try {
      ResponseModel responseModel = await repo.getDPS(id);
      if (responseModel.statusCode == 200) {
        InstallmentResponseModel model = InstallmentResponseModel.fromJson(jsonDecode(responseModel.responseJson));
        if (model.status == "success") {
          dps = model.data;
          installment = model.data?.installments ?? [];
        } else {
          CustomSnackBar.error(errorList: model.message?.error ?? [MyStrings.somethingWentWrong]);
        }
      } else {
        CustomSnackBar.error(errorList: [responseModel.message]);
      }
    } catch (e) {
      printX(e);
    } finally {
      pinController.text = '';
      isDetailsLoading = false;
      update();
    }
  }

  TextEditingController pinController = TextEditingController();

  bool isCloseBtnLoading = false;
  Future<void> closeDPS() async {
    if (pinController.text.isEmpty) {
      CustomSnackBar.error(errorList: ["Please enter your PIN"]);
      return;
    }

    isCloseBtnLoading = true;
    update();
    try {
      ResponseModel responseModel = await repo.closeDPS(id, pinController.text);
      if (responseModel.statusCode == 200) {
        AuthorizationResponseModel model = AuthorizationResponseModel.fromJson(jsonDecode(responseModel.responseJson));
        if (model.status == "success") {
          getDpsHistory();
          Get.back();
          CustomSnackBar.success(successList: model.message?.success ?? [MyStrings.succeed]);
        } else {
          CustomSnackBar.error(errorList: model.message?.error ?? [MyStrings.somethingWentWrong]);
        }
      } else {
        CustomSnackBar.error(errorList: [responseModel.message]);
      }
    } catch (e) {
      printX(e);
    } finally {
      isCloseBtnLoading = false;
      pinController.text = '';
      update();
    }
  }
}
